import subprocess
import multiprocessing
import os




if __name__ == '__main__':

    import argparse
    parser = argparse.ArgumentParser()
    parser.add_argument('--env_names', nargs='+', default=["llf-metaworld-pick-place-v2"])
    parser.add_argument('--n_seeds', type=int, default=10)
    parser.add_argument('--init_seed', type=int, default=0)
    parser.add_argument('--n_optimization_steps', type=int, default=30)
    parser.add_argument('--logdir', type=str, default='exp_results/')
    parser.add_argument('--memory_size', type=int, default=10)
    parser.add_argument('--baseline', action='store_true')
    parser.add_argument('--opro', action='store_true')
    parser.add_argument('--model', type=str, default="gpt-4-0125-preview")
    args = parser.parse_args()

    assert not (args.opro and args.baseline), "Can't have both opro and baseline"
    # log dir name
    if args.opro:
        args.logdir += "/opro"
    elif args.baseline:
        args.logdir += "/baseline"
    elif args.memory_size>0:
        args.logdir += f"/trace_memory{args.memory_size}"
    else:
        args.logdir += "/trace"


    def run(env_name, seed):
        cmd = f'python exp/metaworld_exp.py --env_name {env_name} --logdir {args.logdir} --seed {seed} --n_optimization_steps {args.n_optimization_steps} --model {args.model}'
        if args.baseline:
            cmd += " --baseline"
        if args.opro:
            cmd += " --opro"
        if args.memory_size>0:
            cmd += f" --memory_size {args.memory_size}"
        os.system(cmd)


    for env_name in args.env_names:
        for seed in range(args.init_seed, args.n_seeds):
            run(env_name, seed)
